/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import oracle.install.commons.bean.BeanStore;
import oracle.install.commons.bean.BeanStoreErrorCode;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.properties.PropertiesBeanStoreReader;
import oracle.install.commons.bean.properties.PropertiesBeanStoreWriter;

public class PropertiesBeanStore
extends BeanStore<PropertiesBeanStoreWriter, PropertiesBeanStoreReader> {
    private Properties properties;
    private File propertyFile;
    private boolean caseSensitive;

    public PropertiesBeanStore(File propertyFile) {
        this(new Properties());
        this.propertyFile = propertyFile;
    }

    public PropertiesBeanStore(Properties properties) {
        this(properties, true);
    }

    public PropertiesBeanStore(Properties properties, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        if (properties == null) {
            properties = new Properties();
        }
        this.properties = !caseSensitive ? PropertiesBeanStore.toLowerCase(properties) : properties;
    }

    public File getPropertyFile() {
        return this.propertyFile;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void load() throws BeanStoreException {
        if (this.propertyFile != null) {
            this.properties = new Properties();
            try {
                this.properties.load(new FileInputStream(this.propertyFile));
            }
            catch (IOException e) {
                throw new BeanStoreException((Throwable)e, BeanStoreErrorCode.UNABLE_TO_LOAD_BEANSTORE, new Object[0]);
            }
        }
    }

    @Override
    public void save() throws BeanStoreException {
        if (this.propertyFile != null) {
            try {
                FileOutputStream out = new FileOutputStream(this.propertyFile);
                this.save(out);
                out.close();
            }
            catch (IOException e) {
                throw new BeanStoreException((Throwable)e, BeanStoreErrorCode.UNABLE_TO_SAVE_BEANSTORE, new Object[0]);
            }
        }
    }

    @Override
    public void save(OutputStream out) throws BeanStoreException {
        if (out != null) {
            try {
                this.properties.store(out, this.getBeanStoreName());
            }
            catch (IOException e) {
                throw new BeanStoreException((Throwable)e, BeanStoreErrorCode.UNABLE_TO_SAVE_BEANSTORE, new Object[0]);
            }
        }
    }

    public static Properties toLowerCase(Properties properties) {
        Properties clone = null;
        if (properties != null) {
            clone = new Properties();
            Iterator<Object> i = properties.keySet().iterator();
            while (i.hasNext()) {
                String key = i.next().toString();
                Object value = properties.get(key);
                clone.put(key.toLowerCase(), value);
            }
        }
        return clone;
    }

    @Override
    public PropertiesBeanStoreReader newBeanStoreReader() throws BeanStoreException {
        PropertiesBeanStoreReader reader = new PropertiesBeanStoreReader();
        reader.open(this);
        return reader;
    }

    @Override
    public PropertiesBeanStoreWriter newBeanStoreWriter() throws BeanStoreException {
        PropertiesBeanStoreWriter writer = new PropertiesBeanStoreWriter();
        writer.open(this);
        return writer;
    }
}

